varying vec2 		texcoord;

uniform sampler2D 	dif0;
//					noisemap;
	
#ifdef ALPHATEST

	uniform float 		alphalevel;
	varying float		alphaFade;
	
#endif		

varying vec4 		curpos,
					prev;
uniform float		vScale;
uniform float 		fade;

uniform vec2		dscale0;
uniform vec2		dofs0;

#ifdef PSYSTEM
	varying float 		life;	
	uniform vec4 		particleFade;
#endif

#ifdef BSET
		varying vec4 pcolor;
#endif

// NOISE ----------------------------------------------------
float bayer2(vec2 a){
    a = floor(a);
    return fract( dot(a, vec2(.5, a.y * .75)) );
}

#define bayer4(a)   (bayer2( .5*(a))*.25+bayer2(a))
#define bayer8(a)   (bayer4( .5*(a))*.25+bayer2(a))
#define bayer16(a)  (bayer8( .5*(a))*.25+bayer2(a))
#define bayer32(a)  (bayer16(.5*(a))*.25+bayer2(a))
#define bayer64(a)  (bayer32(.5*(a))*.25+bayer2(a))
#define bayer128(a) (bayer64(.5*(a))*.25+bayer2(a))
// -----------------------------------------------------------

void main()
{
	#ifdef PSYSTEM
	
	if(life<=0.0)
		discard;
			
	#endif
	
	vec2 	screenCoords=prev.xy;
	vec4 	fdcolor;
	
	#ifdef ALPHATEST

		#ifndef _HEIGHTMAP_		
			fdcolor=texture2D(dif0,texcoord.st*dscale0+dofs0);
		#endif
	
		#ifdef PSYSTEM
			float alpha=fdcolor.a*life;
			if(alpha<=alphalevel)
				discard;
		#else
			#ifdef BSET
				float alpha=bayer4(gl_FragCoord.st);//texture2D(noisemap,screenCoords.st).r;
				if(alpha>pcolor.w)
					discard;
			#else
				#ifdef MSET
					float alpha=bayer4(gl_FragCoord.st);//texture2D(noisemap,screenCoords.st*5.0).r;
					if(alpha>fade)
						discard;
				#else
					#ifdef _HEIGHTMAP_
					#else
						#ifdef SKINNING
						#else
							#ifndef _NOT_INSTANCED_
								float alpha=bayer4(gl_FragCoord.st);//texture2D(noisemap,screenCoords.st*5.0).r;
								if(alpha>alphaFade)
									discard;
							#else
								float alpha=bayer4(gl_FragCoord.st);//texture2D(noisemap,screenCoords.st*5.0).r;
								if(alpha>fade)
									discard;
							#endif
						#endif
					#endif
				#endif
			#endif
			
			#ifdef BSET
				if(fdcolor.a<=alphalevel)
					discard;
			#else
				if(fdcolor.a<=mix(alphalevel,alphalevel*0.8,clamp(curpos.z*25000.0-4500.0,0.0,1.0)))
					discard;
			#endif
		#endif
		
	#endif

	// pos
	vec2 vel=((curpos.xy/curpos.w)-(prev.xy/prev.w))*vScale;
	
	// material params
	gl_FragColor.rg=(vel*vec2(0.5))+vec2(0.5);
}
